def transform_html(input_file, output_file):
    try:
        # Read the original HTML content with the source encoding (Windows-874, alias 'cp874')
        with open(input_file, 'r', encoding='cp874') as file:
            content = file.read()

        # At this point, 'content' is a Python string, which is Unicode.
        # Any manipulation you do here is in Unicode.

        # Save the transformed content to a new file, explicitly using UTF-8 encoding.
        # This step encodes the Unicode string into UTF-8 bytes and writes those bytes to the file.
        with open(output_file, 'w', encoding='utf-8') as file:
            file.write(content)

        print(f"Successfully transformed and saved to {output_file}")
    except Exception as e:
        print(f"An error occurred: {e}")

# Usage example
transform_html('web1.html', 'web2.html')

