import sys
import re

def transform_content_and_update_header():
    # Read binary input from stdin buffer
    binary_content = sys.stdin.buffer.read()

    try:
        # Decode the content from 'cp874' to get a Unicode string
        decoded_content = binary_content.decode('cp874')

        # Replace the old HTML header with the new one
        # This regular expression looks for the head section and replaces it
        # with a UTF-8 meta tag and a specified title.
        # Note: This is a simple replacement and may not work for all HTML structures.
        new_head = '''
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Document Title</title>
</head>
'''
        updated_content = re.sub(r'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2//EN">.*?<HEAD>.*?</HEAD>',
                                 new_head, decoded_content, flags=re.DOTALL)

        # Encode the updated content to 'utf-8' and write to stdout buffer
        utf8_content = updated_content.encode('utf-8')
        sys.stdout.buffer.write(utf8_content)

    except UnicodeDecodeError as e:
        sys.stderr.write(f"Decoding error: {e}\n")
    except UnicodeEncodeError as e:
        sys.stderr.write(f"Encoding error: {e}\n")
    except Exception as e:
        sys.stderr.write(f"An unexpected error occurred: {e}\n")

if __name__ == "__main__":
    transform_content_and_update_header()

