#!/bin/bash

# Define the directory where the converted files will be saved
output_dir="newencode"

# Check if the output directory exists, create it if not
if [ ! -d "$output_dir" ]; then
    mkdir "$output_dir"
fi

# Loop over all HTML files in the current directory
for file in *.html; do
    # Define the new filename 
    new_file="${file%.html}.html"
    
    # Use the Python script to convert the file encoding and save it in the new directory
    python3 encodechange.py < "$file" > "$output_dir/$new_file"
    
    echo "Converted $file and saved as $output_dir/$new_file"
done

echo "All HTML files have been converted and saved in $output_dir/"

